#
# Copyright (c) 2001 Gary Renshaw.  Released under the provisions of the GPL.
# Ask some questions and generate the procmailrc file.
#
open FH, ">procmailrc";

$| = 1;

print << "EOF";

Welcome to the Splonk set up program.

The questions are in two sections.
Section 1 deals with your mail preferences.
Section 2 deals with personalising your rc.splonk file.

Section 1
=========

Note: Unless you have a really good reason not to it is probably
best to accept the default values in this section.

To accept the default just press ENTER.  The default value is
shown in [square backets].

EOF

$def_spool = "/var/spool/mail/$ENV{'USER'}";
print "What is your system mail spool file? [$def_spool] ";
answer_1 (\$def_spool);

$def_junk = "junk";
print "In which mail folder do you want to put rejected messages? [$def_junk] ";
answer_1 (\$def_junk);

$def_rubbish = "rubbish";
print "FOR TESTING ONLY:\nIn which mail folder do you want to put rejected messages\n(must not be $def_junk)? [$def_rubbish] ";
answer_1 (\$def_rubbish);

open FH, ">procmailrc";
print FH "#LOGABSTRACT=all\n";
print FH "VERBOSE=off\n";
print FH "\n";
print FH "SPOOL=$def_spool\n";
print FH "# If you are going to test changes to the procmail recipe file\n";
print FH "# comment the first JUNK/BOUNCE definition lines and uncomment\n";
print FH "# the second set.\n";
print FH "# Don't forget to switch things back after testing.\n";
print FH "JUNK=$def_junk\n";
print FH "BOUNCE=$ENV{'HOME'}/mail-bounce/mail-bounce\n";
print FH "#JUNK=$def_rubbish\n";
print FH "#BOUNCE=/bin/suck\n";
print FH "\n";
print FH "MAILDIR=\$HOME/Mail\n";
print FH "PMDIR=\$HOME/splonk\n";
print FH "LOGFILE=\$PMDIR/log\n";
print FH "INCLUDERC=\$PMDIR/rc.splonk\n";
close FH;
print "\nFile generation complete.\n";

print << "EOF";

Section 2
=========

These questions deal with customising your rc.splonk file.

To accept the default just press ENTER.  The default value is
shown in [square backets].

When entering a list of values just enter one value per line.

EOF

$def_test_subject = "no";
print "Do you want the test subject line enabled? [$def_test_subject] ";
answer_1 (\$def_test_subject);
$def_test_subject = lc $def_test_subject;

print "Enter a list of people/organisations whose mail you ALWAYS want to reject: []\n";
answer_n (\@def_morons);

print "Enter a list of mailing lists whose messages you want to ACCEPT: []\n";
answer_n (\@def_lists);

$def_german = "no";
print "Do you want to accept messages in GERMAN? [$def_german] ";
answer_1 (\$def_german);
$def_german = lc $def_german;

print "Enter a list of regular expressions for legitimate E-mail addresses\nfor which you want to ACCEPT mail: []\n";
answer_n (\@def_me);

print "Enter a list of acceptable people/organisations who hide their list\nof recipients: []\n";
answer_n (\@def_hidden);

#
# Actually create the customised rc.splonk now.
#
open FH, "<splonk.template";
@lines = <FH>;
close FH;

open FH, ">rc.splonk";
$uncomment = 0;
foreach $line (@lines) {
    if ($line =~ /^\#TEST-SUBJECT/ && $def_test_subject ne "no") {
	print FH ":0\n";
        print FH "* ^Subject: procmail test\$\n";
        print FH "| /usr/local/bin/mail-bounce -c test\n";
    }
    elsif ($line =~ /^\#MORONS/) {
        foreach $item (@def_morons) {
	    $raw = $item;
	    $item =~ s/\./\\./g;
	    print FH ":0\n";
	    print FH "* From:.+$item\n";
	    print FH "| tee -a \$JUNK | \$BOUNCE -c \"$raw\"\n\n";
	}
    }
    elsif ($line =~ /^\#MAILING-LISTS/) {
        foreach $item (@def_lists) {
	    $item =~ s/\./\\./g;
	    print FH ":0\n";
	    print FH "* From:.+$item\n";
	    print FH "\$SPOOL\n\n";
	}
    }
    elsif ($line =~ /^\#GERMAN/ && $def_german) {
	   $uncomment = 1;
       }
    elsif ($line =~ /^\#HIDDEN/) {
        foreach $item (@def_hidden) {
	    $item =~ s/\./\\./g;
	    print FH ":0\n";
	    print FH "* From:.+$item\n";
	    print FH "\$SPOOL\n\n";
	}
    }
    elsif ($line =~ /^\#VALID-ADDRESS/) {
	foreach $item (@def_me) {
	    $item =~ s/\./\\./g;
	    print FH ":0\n";
	    print FH "* ^TO_$item\n";
	    print FH "\$SPOOL\n\n";
	}
    }
    elsif ($line =~ /VALID-ADDRESS/) {
	$me = "";
	foreach $item (@def_me) {
	    $item =~ s/\./\\./g;
	    $me = "$me|$item";
	}
	$me = '(' . substr ($me, 1) . ')';
	$line =~ s/VALID-ADDRESS/$me/;
	print FH $line;
    }
    else {
	if ($uncomment) {
	    chomp ($line = substr ($line, 1));
	    if ($line ne "") {
		print FH "$line\n";
	    }
	    else {
		$uncomment = 0;
		print FH "\n";
	    }
	}
	else {
	    print FH $line;
	}
    }
}
close FH;

print "rc.splonk has been customised.\n";

#
# Write out the answer file as answers.dat
#
open FH, ">answers.dat";
print FH "#\n";
print FH "# When you fill in the answers there MUST be a completely blank line between\n";
print FH "# the end of your answer and the start of the next question.\n";
print FH "#\n";
print FH "# What is your system mail spool file? [/var/spool/mail/you]\n";
print FH "$def_spool\n\n";

print FH "# In which mail folder do you want to put rejected messages? [junk]\n";
print FH "$def_junk\n\n";

print FH "# TESTING: In which mail folder do you want to put rejected messages? [rubbish]\n";
print FH "$def_rubbish\n\n";

print FH "# Do you want the test subject line enabled? [no]\n";
print FH "$def_test_subject\n\n";

print FH "# list of people/organisations whose mail you ALWAYS want to reject []\n";
foreach $item (@def_morons) {
    print FH "$item\n";
}
print FH "\n";

print FH "# list of mailing lists whose messages you want to ACCEPT []\n";
foreach $item (@def_lists) {
    print FH "$item\n";
}
print FH "\n";

print FH "# Do you want to accept messages in GERMAN? [no]\n";
print FH "$def_german\n\n";

print FH "# regular expressions for legitimate E-mail addresses to ACCEPT []\n";
foreach $item (@def_me) {
    print FH "$item\n";
}
print FH "\n";

print FH "# acceptable people/organisations who hide their list of recipients []\n";
foreach $item (@def_hidden) {
    print FH "$item\n";
}
print FH "\n\n";

print FH "# End of answers\n";
close FH;

exit 0;

###############################################################################
#
# Get a single answer and stuff it into the reference provided.
# Ignored comment lines.
#
sub answer_1 {
    my $item;
    my $reply = $_[0];

    print "\n";
    do {
	$item = <STDIN>;
	chomp $item;
    } while ($item =~ /^\#/);
    $$reply = $item if $item ne "";
}

###############################################################################
#
# Get multiple answers and stuff them into the reference provided.
# Ignored comment lines.
#
sub answer_n {
    my $item;
    my $reply = $_[0];

    print "\n";
    $item = <STDIN>;
    chomp $item;
    if ($item ne "") {
	push @$reply, $item if $item !~ /^\#/;
	while ($item = <STDIN>) {
	    chomp $item;
	    last if $item eq "";
	    push @$reply, $item if $item !~ /^\#/;
	} 
    }
}

###############################################################################
###############################################################################
